<?php

namespace frontend\controllers;

use Codeception\Step\Comment;
use common\helpers\CorsCustom;
use common\models\Configapikey;
use common\models\Globalfunctions;
use common\models\Liquidacion;
use common\models\SicRuta;
use common\models\SicUsuarios;
use common\models\User;
use common\models\Userhistory;
use common\models\Usuario;
use phpDocumentor\Reflection\Types\False_;
use PHPUnit\Util\Log\JSON;
use Yii;
use yii\data\ActiveDataProvider;
use yii\filters\auth\HttpBasicAuth;
use yii\filters\auth\HttpBearerAuth;
use yii\filters\ContentNegotiator;
use yii\web\ForbiddenHttpException;
use yii\web\HttpException;
use yii\web\Response;
use yii\web\ServerErrorHttpException;
use yii\web\UnauthorizedHttpException;

class LoginController extends ActiveController
{
	public $modelClass = SicUsuarios::class;
	public function actions()
	{
		$actions = parent::actions();
		unset($actions["view"], $actions["delete"], $actions["create"], $actions["update"]);

		$actions["index"]["prepareDataProvider"] = [$this, 'prepareDataProvider'];
		return $actions;
	}


	public function actionUpdate()
	{
		throw new \yii\web\HttpException(405, 'Method Not Allowed', "0");
	}

	public function actionCreate()
	{
		$data = \Yii::$app->getRequest()->getBodyParams();

		if (!empty($data["user"]) && !empty($data["pass"])) {
			$filtros =
				[
					"Usuario" => $data["user"],
					"Password" => $data["pass"],
					"estatus" => "A"
				];
			$model = $this->modelClass::findOne($filtros);

			if (!empty($model)) {
				if (!empty($model->idRuta)) {

					$resultado = array(
						"id_usuario" => $model->id,
						"id_cat_perfil" => $model->idCatPerfil,
						"nombre_user" => $model->Usuario,
						"id_ruta" => $model->idRuta,
						"desc_ruta" => SicRuta::findOne($model->idRuta)->DescRuta,
						"dia_semana" => Globalfunctions::getDiaSemanaText(),
					);
					$response = \Yii::$app->getResponse();
					$response->setStatusCode(200);
					$response->content = json_encode($resultado);
					$response->send();
				} else {
					throw new \yii\web\HttpException(401, 'Acceso denegado a la aplicación', 109);
				}
			} else {
				throw new \yii\web\HttpException(401, 'Usuario y/o contraseña incorrecta!', 108);
			}
		} else {
			throw new \yii\web\HttpException(400, 'Bad Request', "8104");
		}
	}

	public function prepareDataProvider()
	{
		//throw new \yii\web\HttpException(405, 'Method Not Allowed', "0");
	}
}
