<?php

namespace frontend\controllers;

use Codeception\Step\Comment;
use common\helpers\CorsCustom;
use common\models\FTFACTG;
use common\models\Globalparams;
use common\models\SACLAVE;
use common\models\SicUsuarios;
use common\models\User;
use common\models\Usuario;
use common\models\Usuariomovil;
use phpDocumentor\Reflection\Types\False_;
use PHPUnit\Util\Log\JSON;
use Yii;
use yii\data\ActiveDataProvider;
use yii\filters\auth\HttpBasicAuth;
use yii\filters\auth\HttpBearerAuth;
use yii\filters\ContentNegotiator;
use yii\rest\ActiveController;
use yii\web\ForbiddenHttpException;
use yii\web\HttpException;
use yii\web\Response;
use yii\web\ServerErrorHttpException;
use yii\web\UnauthorizedHttpException;

class CfdiController extends ActiveController
{
	public $modelClass = FTFACTG::class;

	public function validarRequest($data, $params, $optativos = array())
	{
		if (empty($data)) {
			throw new \yii\web\HttpException(409, 'Datos JSON no válidos en el cuerpo de la solicitud: No se recibio ninguna información', 104);
		}
		foreach ($data as $key => $value) {

			//REvisamos que no envie datos que no se necesitan
			if (!in_array($key, $params)) {
				if (!in_array($key, $optativos)) {
					throw new \yii\web\HttpException(409, 'Datos no requeridos en request [' . $key . ']', 124);
				}
			}
		}

		foreach ($params as $param) {
			$bolEncontro = false;
			foreach ($data as $key => $value) {
				if ($key == $param) {
					$bolEncontro = true;
				}
			}

			if ($bolEncontro == false) {
				if (!in_array($param, $optativos)) {
					throw new \yii\web\HttpException(409, 'Datos JSON no válidos en el cuerpo de la solicitud: Datos faltantes [' . $param . ']', 125);
				}
			}
		}

		foreach ($data as $key => $value) {
			if (empty($value)) {
				throw new \yii\web\HttpException(409, 'Datos JSON no válidos en el cuerpo de la solicitud: Datos con valores vacios o inexistentes [' . $key . '=' . $value . ']', 126);
			}
		}
	}
	public function actions()
	{
		$actions = parent::actions();
		unset($actions["view"]);
		unset($actions["delete"]);
		unset($actions["create"]);
		unset($actions["update"]);
		$actions["index"]["prepareDataProvider"] = [$this, 'prepareDataProvider'];
		return $actions;
	}

	public function behaviors()
	{
		$behaviors = parent::behaviors();
		$behaviors['contentNegotiator'] = [
			'class' => ContentNegotiator::className(),
			'formats' => [
				'application/json' => Response::FORMAT_JSON,
			],
		];
		// remove authentication filter
		$auth = $behaviors['authenticator'];
		unset($behaviors['authenticator']);
		// add CORS filter
		$behaviors['corsFilter'] = [
			'class' => CorsCustom::className(),
		];
		// re-add authentication filter
		$behaviors['authenticator'] = $auth;
		// avoid authentication on CORS-pre-flight requests (HTTP OPTIONS method)
		$behaviors['authenticator']['except'] = ['options'];

		return $behaviors;
	}

	public function actionUpdate() {
		throw new \yii\web\HttpException(405, 'Method Not Allowed', "0");
	}


	/**
	 * @throws HttpException
	 */
	public function prepareDataProvider()
	{
		$data = \Yii::$app->getRequest()->get();
		$this->validarRequest($data,["d"],["cve_mov","id_cliente","razon_social","folio"]);
		$headers = Yii::$app->request->getHeaders();
		$x_api_key=Globalparams::getGlobalVariables(Globalparams::X_API_KEY);
		if($headers["x-api-key"]!=$x_api_key){
			throw new \yii\web\HttpException(409, 'Llave de acceso no autorizada para consumir este recurso', "108");
		}

		$dataResponse=array();
		$listClaves=array();
		$Claves=SACLAVE::find()->all();
		$listClaves[null]="NO ENCONTRADO";
		$filter=[];
		foreach ($Claves as $cl) {
			$listClaves[$cl->PNUMERO]=$cl->PNUMSUC;
		}
		$filter["MFECHAM"]=date("Y-m-d",$data["d"]);
		$convert["cve_mov"]="MCVEMOV";
		$convert["id_cliente"]="TRY_CONVERT(INT, MNUMCTE)";
		$convert["razon_social"]="MRAZON";
		$convert["folio"]="MFOLIOG";
		$strQuery="";
		foreach ($data as $key => $value) {
			if($key!="d"){
				if($key!="razon_social"){
					$filter[$convert[$key]]=$value;
				}else{
					$strQuery=" MRAZON LIKE '%".$value."%' ";
				}
			}
		}
		$Datos=FTFACTG::find()
			->andWhere($filter)
			->andWhere($strQuery)
			->all();
		foreach ($Datos as $dato) {
			array_push($dataResponse, array(
				"id_cliente" => $dato->MNUMCTE,
				"cadena_original" => $dato->MCADORIG,
				"observacion" => $dato->MOBSERV,
				"razon_social" => $dato->MRAZON,
				"cod_postal" => $dato->MCODPOS,
				"cve_mov" => $dato->MCVEMOV,
				"desc_mov" => $listClaves[$dato->MCVEMOV],
				"folio" => $dato->MFOLIOG,
				"folio_fiscal" => $dato->MUUID,
				"metodo_pago" => $dato->MMETPAG,
				"uso_cfdi" => $dato->MUCFDI,
				"created" => $dato->MFECHAM." ".$dato->MHORAM,
				"timbrado" => $dato->MFECTIMBRE,
				"xml" => $dato->MXML,
			));
		}

		$response = \Yii::$app->getResponse();
		$response->setStatusCode(200);
		$response->content = json_encode($dataResponse);
		$response->send();
	}
}
