<?php

namespace frontend\controllers;

use common\helpers\CorsCustom;
use common\models\SicUsuarios;
use common\models\Usuariomovil;
use Yii;
use yii\filters\auth\HttpBearerAuth;
use yii\filters\ContentNegotiator;
use yii\web\Response;

class ActiveController extends \yii\rest\ActiveController
{
	public function validarRequest($data, $params, $optativos = array())
	{
		if (empty($data)) {
			throw new \yii\web\HttpException(409, 'Datos JSON no válidos en el cuerpo de la solicitud: No se recibio ninguna información', 104);
		}
		foreach ($data as $key => $value) {

			//REvisamos que no envie datos que no se necesitan
			if (!in_array($key, $params)) {
				if (!in_array($key, $optativos)) {
					throw new \yii\web\HttpException(409, 'Datos no requeridos en request [' . $key . ']', 124);
				}
			}
		}

		foreach ($params as $param) {
			$bolEncontro = false;
			foreach ($data as $key => $value) {
				if ($key == $param) {
					$bolEncontro = true;
				}
			}

			if ($bolEncontro == false) {
				if (!in_array($param, $optativos)) {
					throw new \yii\web\HttpException(409, 'Datos JSON no válidos en el cuerpo de la solicitud: Datos faltantes [' . $param . ']', 125);
				}
			}
		}

		foreach ($data as $key => $value) {
			if (empty($value)) {
				throw new \yii\web\HttpException(409, 'Datos JSON no válidos en el cuerpo de la solicitud: Datos con valores vacios o inexistentes [' . $key . '=' . $value . ']', 126);
			}
		}
	}

	public static function getUserLogin() {
		$headers = Yii::$app->request->getHeaders();
		$token=trim(str_replace('Bearer', '', $headers["authorization"]));
		return SicUsuarios::find()
			->andWhere("token='".$token."' AND estatus='A' AND CURRENT_TIMESTAMP()<=vigenciaToken")
			->one();
	}
	public function actions()
	{
		$actions = parent::actions();
		unset($actions["view"]);
		unset($actions["delete"]);
		unset($actions["create"]);
		unset($actions["update"]);
		$actions["index"]["prepareDataProvider"] = [$this, 'prepareDataProvider'];
		return $actions;
	}
	public function behaviors()
	{
		$behaviors = parent::behaviors();
		$behaviors['contentNegotiator'] = [
			'class' => ContentNegotiator::className(),
			'formats' => [
				'application/json' => Response::FORMAT_JSON,
				'application/xml' => Response::FORMAT_XML,
			],
		];
		// remove authentication filter
		$auth = $behaviors['authenticator'];
		unset($behaviors['authenticator']);

		// re-add authentication filter
		$behaviors['authenticator'] = $auth;
		// avoid authentication on CORS-pre-flight requests (HTTP OPTIONS method)
		$behaviors['authenticator']['except'] = ['options'];
		$behaviors['authenticator']['only'] = ["delete", "update", "create", "*"]; //APLICA SOLO LA AUTENTICACION A ESTOS METODOS
		$behaviors['authenticator']['authMethods'] = [
			HttpBearerAuth::class
		];
		// add CORS filter
		unset($behaviors['corsFilter']);
		// add CORS filter
		$behaviors['corsFilter'] = [
			'class' => \yii\filters\Cors::className(),
			'cors' => [
				'Origin' => ['*'],
				'Access-Control-Allow-Origin' => ['*'],
				'Access-Control-Request-Method' => ['GET', 'POST', 'PUT', 'PATCH', 'DELETE', 'HEAD', 'OPTIONS'],
				'Access-Control-Request-Headers' => ['*'],
				'Access-Control-Allow-Credentials' => null,
				'Access-Control-Max-Age' => 86400,
				'Access-Control-Expose-Headers' => []
			]
		];
		return $behaviors;
	}
}
