<?php


$params = array_merge(
    require __DIR__ . '/../../common/config/params.php',
    require __DIR__ . '/../../common/config/params-local.php',
    require __DIR__ . '/params.php',
    require __DIR__ . '/params-local.php'
);

return [
    'id' => 'app-frontend',
    'basePath' => dirname(__DIR__),
    'bootstrap' => ['log'],
    'controllerNamespace' => 'frontend\controllers',
    'components' => [
        'request' => [
            'csrfParam' => '_csrf-frontend',
            'parsers' => [
                'application/json' => \yii\web\JsonParser::class,
                'multipart/form-data' => 'yii\web\MultipartFormDataParser'
            ]
        ],
		'response' => [
			'on beforeSend' => function ($event) {
				$response = $event->sender;
				//$response->headers->add('Access-Control-Allow-Origin', '*'); // Permitir todos los orígenes. Cambia '*' por tu dominio específico si es necesario.
				//$response->headers->add('Access-Control-Allow-Origin', '*');

				$response->headers->add('Access-Control-Allow-Methods', 'GET, POST, PUT, DELETE, OPTIONS');
				$response->headers->add('Access-Control-Allow-Headers', '*');
				$response->headers->add('Access-Control-Allow-Credentials', true);
				//$response->headers->add('Access-Control-Allow-Credentials', false);
			},
		],
        'user' => [
            'identityClass' => 'common\models\User',
            'enableAutoLogin' => true,
            'identityCookie' => ['name' => '_identity-frontend', 'httpOnly' => true],
        ],

        'log' => [
            'traceLevel' => YII_DEBUG ? 3 : 0,
            'targets' => [
                [
                    'class' => 'yii\log\FileTarget',
                    'levels' => ['error', 'warning'],
                ],
            ],
        ],
        'errorHandler' => [
            'errorAction' => 'site/error',
        ],

        'urlManager' => [
            'enablePrettyUrl' => true,
            'enableStrictParsing' => false,
            'showScriptName' => false,
            'rules' => [
                '<controller:\w+>/<action:\w+>' => '<controller>/<action>',
                '<controller:\w+>/<action:\w+>/<id:\d+>' => '<controller>/<action>',
                'PUT <controller:\w+>' => '<controller>/update',
                'DELETE <controller:\w+>' => '<controller>/delete',
                'POST <controller:\w+>' => '<controller>/create',
                [
                    "class" => \yii\rest\UrlRule::class,
                    'controller' => [
                        'token', 'rutatrabajo','visitas','cveradio',
                        'rutatrabajoestatus',
                    ],

                ],

            ],
        ],

    ],
    'params' => $params,
	'on beforeRequest' => function ($event) {
		header("Access-Control-Allow-Origin: *");
		header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
		header("Access-Control-Allow-Headers: Authorization, Content-Type, X-Requested-With");
		if (Yii::$app->getRequest()->getMethod() === 'OPTIONS') {
			Yii::$app->end();
		}
	},
];
