<?php


namespace common\models;

use Yii;
use yii\base\NotSupportedException;
use yii\behaviors\TimestampBehavior;
use yii\db\ActiveRecord;
use yii\web\HeaderCollection;
use yii\web\IdentityInterface;
use yii\web\UnauthorizedHttpException;

/**
 * This is the model class for table "{{%user}}".
 *
 * @property int $id
 * @property string $key
 * @property string $createdAt
 * @property string $createdBy
 * @property string $estatus
 * @property string $aplicacion
 * @property string $usuario
 * @property string|null $updatedAt
 * @property string|null $updatedBy
 * @property string|null $observacion
 */
class User extends ActiveRecord implements IdentityInterface {
	const STATUS_DELETED = 0;
	const STATUS_INACTIVE = "B";
	const STATUS_ACTIVE = "A";

	public function fields() {
		return ["id", "username", "createdAt", "vigencia", "token", "type"];
	}

	public function generateAccessToken() {
		$this->token = Yii::$app->security->generateRandomString();
		return $this->token;
	}

	/**
	 * {@inheritdoc}
	 */
	public static function tableName() {
		return '{{%usuariomovil}}';
	}

	/**
	 * {@inheritdoc}
	 */
	/*public function behaviors()
	{
		return [
			TimestampBehavior::className(),
		];
	}*/

	/**
	 * {@inheritdoc}
	 */
	public function rules() {
		return [
			[['username', 'estatus', 'token', 'vigencia', 'password', 'createdAt', 'createdBy', 'type'], 'required'],
			[['vigencia', 'createdAt', 'updatedAt'], 'safe'],
			[['username', 'token'], 'string', 'max' => 255],
			[['estatus', 'type'], 'string', 'max' => 1],
			[['password'], 'string', 'max' => 160],
			[['createdBy', 'updatedBy'], 'string', 'max' => 45],
			[['username'], 'unique'],
			['estatus', 'default', 'value' => self::STATUS_ACTIVE],
		];
	}

	/**
	 * {@inheritdoc}
	 */
	public static function findIdentity($id) {
		return static::findOne(['id' => $id, 'estatus' => self::STATUS_ACTIVE]);
	}

	/**
	 * {@inheritdoc}
	 */
	public static function findIdentityByAccessToken($token, $type = null) {
		$apiKey = Yii::$app->request->getHeaders();
		$key = Globalparams::getGlobalVariables(Globalparams::X_API_KEY);

		if ($apiKey["x-api-key"] == $key) {
			$tokenBeaber = SicUsuarios::find()->where(['estatus' => self::STATUS_ACTIVE, "token" => self::getTokenSend()])->one();

			//validar vigencia
			if (!empty($tokenBeaber)) {
				if ($tokenBeaber->vigenciaToken > date("Y-m-d H:i:s")) {

					if (sha1($tokenBeaber->clientId . $apiKey["client_secret"]) == $tokenBeaber->token){
						return $tokenBeaber;
					} else {
						throw new \yii\web\HttpException(403, 'Acceso denegado, usuario no reconocido', 10311);
					}
				} else {
					throw new \yii\web\HttpException(401, 'La vigencia del token ha expirado.', 102);
				}
			} else {
				throw new \yii\web\HttpException(403, 'Acceso denegado, usuario no reconocido.', 1010);
			}
		} else {
			throw new \yii\web\HttpException(403, 'Acceso denegado, llave no autorizada K.', 100);
		}
	}

	/**
	 * Finds user by username
	 *
	 * @param string $username
	 * @return static|null
	 */
	public static function findByUsername($username) {
		return static::findOne(['username' => $username, 'estatus' => self::STATUS_ACTIVE]);
	}

	/**
	 * Finds user by password reset token
	 *
	 * @param string $token password reset token
	 * @return static|null
	 */
	public static function findByPasswordResetToken($token) {
		if (!static::isPasswordResetTokenValid($token)) {
			return null;
		}

		return static::findOne([
			'password_reset_token' => $token,
			'status' => self::STATUS_ACTIVE,
		]);
	}

	/**
	 * Finds user by verification email token
	 *
	 * @param string $token verify email token
	 * @return static|null
	 */
	public static function findByVerificationToken($token) {

		return Usuario::find()
			->andWhere("token='" . $token . "' AND estatus='A' AND CURRENT_TIMESTAMP()<=vigenciaToken")
			->one();
	}

	public static function getParamHeaders() {
		$headers = Yii::$app->request->getHeaders();
		$response = array();
		$response["authorization"] = null;
		if (!empty($headers["authorization"])) {
			$response["authorization"] = trim(str_replace("Bearer ", "", $headers["authorization"]));
		}
		return $response;
	}

	/**
	 * Finds out if password reset token is valid
	 *
	 * @param string $token password reset token
	 * @return bool
	 */
	public static function isPasswordResetTokenValid($token) {
		if (empty($token)) {
			return false;
		}

		$timestamp = (int)substr($token, strrpos($token, '_') + 1);
		$expire = Yii::$app->params['user.passwordResetTokenExpire'];
		return $timestamp + $expire >= time();
	}

	/**
	 * {@inheritdoc}
	 */
	public function getId() {
		return $this->getPrimaryKey();
	}

	/**
	 * {@inheritdoc}
	 */
	public function getAuthKey() {
		//return $this->auth_key;
	}

	/**
	 * {@inheritdoc}
	 */
	public function validateAuthKey($authKey) {
		return $this->getAuthKey() === $authKey;
	}

	/**
	 * Validates password
	 *
	 * @param string $password password to validate
	 * @return bool if password provided is valid for current user
	 */
	public function validatePassword($password) {
		return Yii::$app->security->validatePassword($password, $this->password);
	}

	/**
	 * Generates password hash from password and sets it to the model
	 *
	 * @param string $password
	 */
	public function setPassword($password) {
		$this->password = sha1($password);
	}

	/**
	 * Generates "remember me" authentication key
	 */
	public function generateAuthKey() {
		$this->token = Yii::$app->security->generateRandomString();
	}

	public static function validateStrongPassword($password) {
		//MIN 8 CARACTERES
		//1 MAYUSCULA
		//1 MINUSUCLA
		//ALGÚN NUMERO
		$response = array();
		$response["status"] = 200;
		if (strlen($password) < 8) {
			$response["status"] = 201;
			$response["code"] = 106;
		}
		return $response;
	}

	/**
	 * Generates new password reset token
	 */


	public function generatePasswordResetToken() {
		$this->password = Yii::$app->security->generateRandomString() . '_' . time();
	}

	/**
	 * Generates new token for email verification
	 */
	public function generateEmailVerificationToken() {
		$this->token = Yii::$app->security->generateRandomString() . '_' . time();
	}

	/**
	 * Removes password reset token
	 */
	public function removePasswordResetToken() {
		$this->token = null;
	}

	public static function getTokenSend() {
		$headers = Yii::$app->request->headers;
		$accept = $headers->get('authorization');
		$token = str_replace("Bearer ", "", $accept);
		return $token;
	}
}
