<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "SASUCUR".
 *
 * @property string $SNUMSUC
 * @property string|null $SNOMBRE
 * @property int $SBAJA
 * @property string $SCALLE
 * @property string $SNUMEXT
 * @property string $SNUMINT
 * @property string $SREFEREN
 * @property string $SCOLON
 * @property string $SDELMUN
 * @property string $SCIUDAD
 * @property string $SPAIS
 * @property string $SCODEST
 * @property string $SCODPOS
 * @property string|null $SCVECOL
 * @property string|null $SCVEMUN
 * @property string|null $SCVELOC
 * @property string|null $SCVEPAIS
 *
 * @property SAALMAC[] $sAALMACs
 * @property SACLAVE[] $sACLAVEs
 */
class SASUCUR extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'SASUCUR';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['SNUMSUC', 'SBAJA', 'SCALLE', 'SNUMEXT', 'SNUMINT', 'SREFEREN', 'SCOLON', 'SDELMUN', 'SCIUDAD', 'SPAIS', 'SCODEST', 'SCODPOS'], 'required'],
            [['SBAJA'], 'integer'],
            [['SNUMSUC'], 'string', 'max' => 6],
            [['SNOMBRE', 'SCIUDAD'], 'string', 'max' => 40],
            [['SCALLE', 'SREFEREN', 'SDELMUN', 'SPAIS'], 'string', 'max' => 50],
            [['SNUMEXT', 'SNUMINT', 'SCODPOS'], 'string', 'max' => 10],
            [['SCOLON'], 'string', 'max' => 60],
            [['SCODEST', 'SCVEMUN', 'SCVEPAIS'], 'string', 'max' => 3],
            [['SCVECOL'], 'string', 'max' => 4],
            [['SCVELOC'], 'string', 'max' => 2],
            [['SNUMSUC'], 'unique'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'SNUMSUC' => 'Snumsuc',
            'SNOMBRE' => 'Snombre',
            'SBAJA' => 'Sbaja',
            'SCALLE' => 'Scalle',
            'SNUMEXT' => 'Snumext',
            'SNUMINT' => 'Snumint',
            'SREFEREN' => 'Sreferen',
            'SCOLON' => 'Scolon',
            'SDELMUN' => 'Sdelmun',
            'SCIUDAD' => 'Sciudad',
            'SPAIS' => 'Spais',
            'SCODEST' => 'Scodest',
            'SCODPOS' => 'Scodpos',
            'SCVECOL' => 'Scvecol',
            'SCVEMUN' => 'Scvemun',
            'SCVELOC' => 'Scveloc',
            'SCVEPAIS' => 'Scvepais',
        ];
    }

    /**
     * Gets query for [[SAALMACs]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getSAALMACs()
    {
        return $this->hasMany(SAALMAC::class, ['LNUMSUC' => 'SNUMSUC']);
    }

    /**
     * Gets query for [[SACLAVEs]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getSACLAVEs()
    {
        return $this->hasMany(SACLAVE::class, ['PNUMSUC' => 'SNUMSUC']);
    }
}
