<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "SACLAVE".
 *
 * @property string $PNUMERO
 * @property string|null $PDESCR
 * @property string|null $PDESCOR
 * @property string|null $PNUMSUC
 * @property string $PFORMA
 * @property string|null $PNATURA
 * @property string|null $PENOSAL
 * @property float $PSIGNO
 * @property string|null $PMODULO
 * @property string $PTIPOPOL
 * @property string|null $PCVEMON
 * @property string|null $POBSERV
 * @property string|null $PLAB
 * @property string|null $PFLETE
 * @property string|null $PEMBARQ
 * @property float $PCVEIVA
 * @property float $PCVEIVAR
 * @property float $PCVEISRR
 * @property float $PCVEIEPS
 * @property int $PIVAINC
 * @property int $PIEPSINC
 * @property int $PIVAREN
 * @property int $PIVARENR
 * @property int $PIEPSREN
 * @property string|null $PFOLPRI
 * @property float|null $PFOLIO
 * @property string $PSERIE
 * @property float|null $PULTFOL
 * @property string|null $PNUMAPRO
 * @property float $PLISPRE
 * @property int $PPREANT
 * @property int $PVIGIM
 * @property int $PNOCANT
 * @property float|null $PNUMCOP
 * @property int $PTRASPA
 * @property int $PCFDI
 * @property string|null $PFECAPRO
 * @property string|null $PLLAPRIV
 * @property string|null $PPASSWD
 * @property string|null $PNUMCER
 * @property string|null $PCERTIF
 * @property string|null $PFECFINCER
 * @property string|null $PHORFINCER
 * @property int $PLUGEXP
 * @property string|null $PCALLE
 * @property string|null $PNUMEXT
 * @property string|null $PNUMINT
 * @property string|null $PREFEREN
 * @property string|null $PCOLON
 * @property string|null $PDELMUN
 * @property string|null $PCIUDAD
 * @property string|null $PCODEST
 * @property string|null $PPAIS
 * @property string $PCODPOS
 * @property string|null $PREGFIS
 * @property int $PPARCIAL
 * @property int $PFACPAGCOM
 * @property string|null $PCTACARTE
 * @property int $PBAJA
 * @property string|null $PCTAVTA
 * @property string|null $PNUMCENVTA
 * @property string|null $PCTACTO
 * @property string|null $PNUMCENCTO
 * @property int $PVIGIM2
 * @property float $PNUMCOP2
 * @property string|null $PFORMA2
 * @property string|null $PCVEUSO
 * @property float $PPORLOC
 * @property int $PLOCINC
 * @property int $PLOCREN
 * @property float $PPORLOCR
 * @property string $PCODPROFG
 * @property string $PCVECREFG
 * @property int $PTOTBD
 * @property string|null $PDESCBD
 * @property string|null $PCVEPSBD
 * @property string|null $PMEDSATBD
 * @property int $PINVFOL
 * @property int $PCARPOR
 * @property int $PANTICIPO
 *
 * @property BDCORTE[] $bDCORTEs
 * @property BDSOLPA[] $bDSOLPAs
 * @property BDSOLPA[] $bDSOLPAs0
 * @property CAPOLFI[] $cAPOLFIs
 * @property CDTRANS[] $cDTRANSs
 * @property FDCOTIG[] $fDCOTIGs
 * @property FDEACUG[] $fDEACUGs
 * @property FDLISTG[] $fDLISTGs
 * @property FDPEDIG[] $fDPEDIGs
 * @property FTFACTD[] $fTFACTDs
 * @property FTFACTG[] $fTFACTGs
 * @property FTPORTD[] $fTPORTDs
 * @property FTPORTG[] $fTPORTGs
 * @property IDENSAG[] $iDENSAGs
 * @property IDENTRG[] $iDENTRGs
 * @property IDORDEG[] $iDORDEGs
 * @property IDREQUG[] $iDREQUGs
 * @property IDTRASG[] $iDTRASGs
 * @property CACUENT $pCTACARTE
 * @property CACUENT $pCTACTO
 * @property CACUENT $pCTAVTA
 * @property SATIPMO $pCVEMON
 * @property SACLAVE $pFOLPRI
 * @property CACENTR $pNUMCENCTO
 * @property CACENTR $pNUMCENVTA
 * @property SASUCUR $pNUMSUC
 * @property SACLAVE[] $sACLAVEs
 * @property SACONPA[] $sACONPAs
 */
class SACLAVE extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'SACLAVE';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['PNUMERO', 'PFORMA', 'PSIGNO', 'PTIPOPOL', 'PCVEIVA', 'PCVEIVAR', 'PCVEISRR', 'PCVEIEPS', 'PIVAINC', 'PIEPSINC', 'PIVAREN', 'PIVARENR', 'PIEPSREN', 'PSERIE', 'PLISPRE', 'PPREANT', 'PVIGIM', 'PNOCANT', 'PTRASPA', 'PCFDI', 'PLUGEXP', 'PCODPOS', 'PPARCIAL', 'PFACPAGCOM', 'PBAJA', 'PVIGIM2', 'PNUMCOP2', 'PPORLOC', 'PLOCINC', 'PLOCREN', 'PPORLOCR', 'PCODPROFG', 'PCVECREFG', 'PTOTBD', 'PINVFOL', 'PCARPOR', 'PANTICIPO'], 'required'],
            [['PSIGNO', 'PCVEIVA', 'PCVEIVAR', 'PCVEISRR', 'PCVEIEPS', 'PFOLIO', 'PULTFOL', 'PLISPRE', 'PNUMCOP', 'PNUMCOP2', 'PPORLOC', 'PPORLOCR'], 'number'],
            [['PIVAINC', 'PIEPSINC', 'PIVAREN', 'PIVARENR', 'PIEPSREN', 'PPREANT', 'PVIGIM', 'PNOCANT', 'PTRASPA', 'PCFDI', 'PLUGEXP', 'PPARCIAL', 'PFACPAGCOM', 'PBAJA', 'PVIGIM2', 'PLOCINC', 'PLOCREN', 'PTOTBD', 'PINVFOL', 'PCARPOR', 'PANTICIPO'], 'integer'],
            [['PFECAPRO', 'PFECFINCER'], 'safe'],
            [['PNUMERO', 'PNUMSUC', 'PFORMA', 'PFLETE', 'PFOLPRI', 'PNUMCENVTA', 'PNUMCENCTO', 'PFORMA2', 'PCVECREFG'], 'string', 'max' => 6],
            [['PDESCR'], 'string', 'max' => 30],
            [['PDESCOR', 'PHORFINCER'], 'string', 'max' => 8],
            [['PNATURA', 'PENOSAL', 'PMODULO', 'PTIPOPOL'], 'string', 'max' => 1],
            [['PCVEMON', 'PSERIE', 'PCODEST', 'PREGFIS', 'PCVEUSO', 'PMEDSATBD'], 'string', 'max' => 3],
            [['POBSERV', 'PLAB'], 'string', 'max' => 15],
            [['PEMBARQ'], 'string', 'max' => 24],
            [['PNUMAPRO', 'PNUMEXT', 'PNUMINT', 'PCODPOS', 'PCVEPSBD'], 'string', 'max' => 10],
            [['PLLAPRIV', 'PCERTIF'], 'string', 'max' => 2500],
            [['PPASSWD', 'PCALLE', 'PREFEREN', 'PDELMUN', 'PPAIS'], 'string', 'max' => 50],
            [['PNUMCER', 'PCTACARTE', 'PCTAVTA', 'PCTACTO', 'PCODPROFG'], 'string', 'max' => 20],
            [['PCOLON'], 'string', 'max' => 60],
            [['PCIUDAD', 'PDESCBD'], 'string', 'max' => 40],
            [['PNUMERO'], 'unique'],
            [['PNUMSUC'], 'exist', 'skipOnError' => true, 'targetClass' => SASUCUR::class, 'targetAttribute' => ['PNUMSUC' => 'SNUMSUC']],
            [['PFOLPRI'], 'exist', 'skipOnError' => true, 'targetClass' => SACLAVE::class, 'targetAttribute' => ['PFOLPRI' => 'PNUMERO']],
            [['PCVEMON'], 'exist', 'skipOnError' => true, 'targetClass' => SATIPMO::class, 'targetAttribute' => ['PCVEMON' => 'PCVEMON']],
            [['PCTACTO'], 'exist', 'skipOnError' => true, 'targetClass' => CACUENT::class, 'targetAttribute' => ['PCTACTO' => 'MCUENTA']],
            [['PCTAVTA'], 'exist', 'skipOnError' => true, 'targetClass' => CACUENT::class, 'targetAttribute' => ['PCTAVTA' => 'MCUENTA']],
            [['PCTACARTE'], 'exist', 'skipOnError' => true, 'targetClass' => CACUENT::class, 'targetAttribute' => ['PCTACARTE' => 'MCUENTA']],
            [['PNUMCENCTO'], 'exist', 'skipOnError' => true, 'targetClass' => CACENTR::class, 'targetAttribute' => ['PNUMCENCTO' => 'GNUMCEN']],
            [['PNUMCENVTA'], 'exist', 'skipOnError' => true, 'targetClass' => CACENTR::class, 'targetAttribute' => ['PNUMCENVTA' => 'GNUMCEN']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'PNUMERO' => 'Pnumero',
            'PDESCR' => 'Pdescr',
            'PDESCOR' => 'Pdescor',
            'PNUMSUC' => 'Pnumsuc',
            'PFORMA' => 'Pforma',
            'PNATURA' => 'Pnatura',
            'PENOSAL' => 'Penosal',
            'PSIGNO' => 'Psigno',
            'PMODULO' => 'Pmodulo',
            'PTIPOPOL' => 'Ptipopol',
            'PCVEMON' => 'Pcvemon',
            'POBSERV' => 'Pobserv',
            'PLAB' => 'Plab',
            'PFLETE' => 'Pflete',
            'PEMBARQ' => 'Pembarq',
            'PCVEIVA' => 'Pcveiva',
            'PCVEIVAR' => 'Pcveivar',
            'PCVEISRR' => 'Pcveisrr',
            'PCVEIEPS' => 'Pcveieps',
            'PIVAINC' => 'Pivainc',
            'PIEPSINC' => 'Piepsinc',
            'PIVAREN' => 'Pivaren',
            'PIVARENR' => 'Pivarenr',
            'PIEPSREN' => 'Piepsren',
            'PFOLPRI' => 'Pfolpri',
            'PFOLIO' => 'Pfolio',
            'PSERIE' => 'Pserie',
            'PULTFOL' => 'Pultfol',
            'PNUMAPRO' => 'Pnumapro',
            'PLISPRE' => 'Plispre',
            'PPREANT' => 'Ppreant',
            'PVIGIM' => 'Pvigim',
            'PNOCANT' => 'Pnocant',
            'PNUMCOP' => 'Pnumcop',
            'PTRASPA' => 'Ptraspa',
            'PCFDI' => 'Pcfdi',
            'PFECAPRO' => 'Pfecapro',
            'PLLAPRIV' => 'Pllapriv',
            'PPASSWD' => 'Ppasswd',
            'PNUMCER' => 'Pnumcer',
            'PCERTIF' => 'Pcertif',
            'PFECFINCER' => 'Pfecfincer',
            'PHORFINCER' => 'Phorfincer',
            'PLUGEXP' => 'Plugexp',
            'PCALLE' => 'Pcalle',
            'PNUMEXT' => 'Pnumext',
            'PNUMINT' => 'Pnumint',
            'PREFEREN' => 'Preferen',
            'PCOLON' => 'Pcolon',
            'PDELMUN' => 'Pdelmun',
            'PCIUDAD' => 'Pciudad',
            'PCODEST' => 'Pcodest',
            'PPAIS' => 'Ppais',
            'PCODPOS' => 'Pcodpos',
            'PREGFIS' => 'Pregfis',
            'PPARCIAL' => 'Pparcial',
            'PFACPAGCOM' => 'Pfacpagcom',
            'PCTACARTE' => 'Pctacarte',
            'PBAJA' => 'Pbaja',
            'PCTAVTA' => 'Pctavta',
            'PNUMCENVTA' => 'Pnumcenvta',
            'PCTACTO' => 'Pctacto',
            'PNUMCENCTO' => 'Pnumcencto',
            'PVIGIM2' => 'Pvigim2',
            'PNUMCOP2' => 'Pnumcop2',
            'PFORMA2' => 'Pforma2',
            'PCVEUSO' => 'Pcveuso',
            'PPORLOC' => 'Pporloc',
            'PLOCINC' => 'Plocinc',
            'PLOCREN' => 'Plocren',
            'PPORLOCR' => 'Pporlocr',
            'PCODPROFG' => 'Pcodprofg',
            'PCVECREFG' => 'Pcvecrefg',
            'PTOTBD' => 'Ptotbd',
            'PDESCBD' => 'Pdescbd',
            'PCVEPSBD' => 'Pcvepsbd',
            'PMEDSATBD' => 'Pmedsatbd',
            'PINVFOL' => 'Pinvfol',
            'PCARPOR' => 'Pcarpor',
            'PANTICIPO' => 'Panticipo',
        ];
    }

    /**
     * Gets query for [[BDCORTEs]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getBDCORTEs()
    {
        return $this->hasMany(BDCORTE::class, ['MCVEMOV' => 'PNUMERO']);
    }

    /**
     * Gets query for [[BDSOLPAs]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getBDSOLPAs()
    {
        return $this->hasMany(BDSOLPA::class, ['TCVESOL' => 'PNUMERO']);
    }

    /**
     * Gets query for [[BDSOLPAs0]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getBDSOLPAs0()
    {
        return $this->hasMany(BDSOLPA::class, ['TCVEMOV' => 'PNUMERO']);
    }

    /**
     * Gets query for [[CAPOLFIs]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getCAPOLFIs()
    {
        return $this->hasMany(CAPOLFI::class, ['TCVEMOV' => 'PNUMERO']);
    }

    /**
     * Gets query for [[CDTRANSs]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getCDTRANSs()
    {
        return $this->hasMany(CDTRANS::class, ['TCVEMOV' => 'PNUMERO']);
    }

    /**
     * Gets query for [[FDCOTIGs]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getFDCOTIGs()
    {
        return $this->hasMany(FDCOTIG::class, ['MCVEMOV' => 'PNUMERO']);
    }

    /**
     * Gets query for [[FDEACUGs]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getFDEACUGs()
    {
        return $this->hasMany(FDEACUG::class, ['MCVEMOV' => 'PNUMERO']);
    }

    /**
     * Gets query for [[FDLISTGs]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getFDLISTGs()
    {
        return $this->hasMany(FDLISTG::class, ['MCVETRA' => 'PNUMERO']);
    }

    /**
     * Gets query for [[FDPEDIGs]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getFDPEDIGs()
    {
        return $this->hasMany(FDPEDIG::class, ['MCVEMOV' => 'PNUMERO']);
    }

    /**
     * Gets query for [[FTFACTDs]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getFTFACTDs()
    {
        return $this->hasMany(FTFACTD::class, ['MCVEPED' => 'PNUMERO']);
    }

    /**
     * Gets query for [[FTFACTGs]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getFTFACTGs()
    {
        return $this->hasMany(FTFACTG::class, ['MCVEMOV' => 'PNUMERO']);
    }

    /**
     * Gets query for [[FTPORTDs]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getFTPORTDs()
    {
        return $this->hasMany(FTPORTD::class, ['MCVEPED' => 'PNUMERO']);
    }

    /**
     * Gets query for [[FTPORTGs]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getFTPORTGs()
    {
        return $this->hasMany(FTPORTG::class, ['MCVEMOV' => 'PNUMERO']);
    }

    /**
     * Gets query for [[IDENSAGs]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getIDENSAGs()
    {
        return $this->hasMany(IDENSAG::class, ['MCVEMOV' => 'PNUMERO']);
    }

    /**
     * Gets query for [[IDENTRGs]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getIDENTRGs()
    {
        return $this->hasMany(IDENTRG::class, ['MCVEMOV' => 'PNUMERO']);
    }

    /**
     * Gets query for [[IDORDEGs]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getIDORDEGs()
    {
        return $this->hasMany(IDORDEG::class, ['MCVEMOV' => 'PNUMERO']);
    }

    /**
     * Gets query for [[IDREQUGs]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getIDREQUGs()
    {
        return $this->hasMany(IDREQUG::class, ['MCVEMOV' => 'PNUMERO']);
    }

    /**
     * Gets query for [[IDTRASGs]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getIDTRASGs()
    {
        return $this->hasMany(IDTRASG::class, ['MCVEMOV' => 'PNUMERO']);
    }

    /**
     * Gets query for [[PCTACARTE]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getPCTACARTE()
    {
        return $this->hasOne(CACUENT::class, ['MCUENTA' => 'PCTACARTE']);
    }

    /**
     * Gets query for [[PCTACTO]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getPCTACTO()
    {
        return $this->hasOne(CACUENT::class, ['MCUENTA' => 'PCTACTO']);
    }

    /**
     * Gets query for [[PCTAVTA]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getPCTAVTA()
    {
        return $this->hasOne(CACUENT::class, ['MCUENTA' => 'PCTAVTA']);
    }

    /**
     * Gets query for [[PCVEMON]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getPCVEMON()
    {
        return $this->hasOne(SATIPMO::class, ['PCVEMON' => 'PCVEMON']);
    }

    /**
     * Gets query for [[PFOLPRI]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getPFOLPRI()
    {
        return $this->hasOne(SACLAVE::class, ['PNUMERO' => 'PFOLPRI']);
    }

    /**
     * Gets query for [[PNUMCENCTO]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getPNUMCENCTO()
    {
        return $this->hasOne(CACENTR::class, ['GNUMCEN' => 'PNUMCENCTO']);
    }

    /**
     * Gets query for [[PNUMCENVTA]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getPNUMCENVTA()
    {
        return $this->hasOne(CACENTR::class, ['GNUMCEN' => 'PNUMCENVTA']);
    }

    /**
     * Gets query for [[PNUMSUC]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getPNUMSUC()
    {
        return $this->hasOne(SASUCUR::class, ['SNUMSUC' => 'PNUMSUC']);
    }

    /**
     * Gets query for [[SACLAVEs]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getSACLAVEs()
    {
        return $this->hasMany(SACLAVE::class, ['PFOLPRI' => 'PNUMERO']);
    }

    /**
     * Gets query for [[SACONPAs]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getSACONPAs()
    {
        return $this->hasMany(SACONPA::class, ['PCVEMOV' => 'PNUMERO']);
    }
}
