<?php

namespace common\models;

use DateTime;
use Yii;


class Globalfunctions extends \yii\db\ActiveRecord
{
	public static function getDateDiff($fecha,$diferencia){
		$fecha = new DateTime($fecha);
		$fecha->modify($diferencia);
		return $fecha->format('Y-m-d H:i:s');
	}

	public static function getDiaSemanaText() {
		$diaIngles=strftime("%A", strtotime(date("Y-m-d")));
		$daysFull = [
			'Monday'    => 'lunes',
			'Tuesday'   => 'martes',
			'Wednesday' => 'miércoles',
			'Thursday'  => 'jueves',
			'Friday'    => 'viernes',
			'Saturday'  => 'sábado',
			'Sunday'    => 'domingo',
		];

		return mb_strtoupper($daysFull[$diaIngles]);
	}
	public static function getDiaSemanaIndex() {
		return (int) date('N');
	}

	public static function esMayor($f1, $f2, ?DateTimeZone $tz = null): bool {
		$t1 = strtotime($f1);
		$t2 = strtotime($f2);
		if ($t1 === false || $t2 === false) {
			throw new \yii\web\HttpException(409, 'Fecha erronea', "111");
		}
		return $t1 > $t2;
	}
}
