<?php

namespace common\models;

use setasign\Fpdi\PdfParser\Filter\Lzw;
use Yii;


class GlobalFunctionsGPS extends \yii\db\ActiveRecord
{

	const LATITUD="gps.latitud";
	const LONGITUD="gps.longitud";
	public static function getDistanciaUbicaciones(float $lat1, float $lon1, float $lat2, float $lon2): float
	{
		// Radio medio de la Tierra en metros
		$R = 6371008.8;

		$phi1 = deg2rad($lat1);
		$phi2 = deg2rad($lat2);
		$dphi = deg2rad($lat2 - $lat1);
		$dlambda = deg2rad($lon2 - $lon1);

		$a = sin($dphi/2) ** 2 + cos($phi1) * cos($phi2) * sin($dlambda/2) ** 2;
		$c = 2 * atan2(sqrt($a), sqrt(1-$a));

		return $R * $c; //lo regresa en metros
	}

	public static function LATITUD_EMPRESA() {
		return "19.299490831814804";
	}

	public static function  LONGITUD_EMPRESA() {
		return "-99.11257429334496";
	}

	public static function LIMITE_ACTIVACION_MOVIL() {
		//LIMITE EN METROS
		return 100;
	}

}
