<?php

namespace common\models;

use Yii;
use yii\httpclient\Client;
use yii\web\UnauthorizedHttpException;


class FunctionApi extends \yii\db\ActiveRecord
{
	const POST = "POST";
	const PUT = "PUT";
	const GET = "GET";
	const DELETE = "DELETE";
	const FORMAT_RAW_URLENCODED = \yii\httpclient\Client::FORMAT_RAW_URLENCODED;
	const FORMAT_JSON = \yii\httpclient\Client::FORMAT_JSON;
	public static function exeDataApi($Method, $endPoint, $data, $Params, $format = \yii\httpclient\Client::FORMAT_JSON)
	{
		$client = new Client();

		$headers["Content-Type"] = "application/json";
		foreach ($Params as $key => $param) {
			if ($key != "url") {
				if ($key == "auth") {
					$headers["Authorization"] = $param;
				} else {
					$headers[$key] = $param;
				}
			}
		}

		$response = $client->createRequest()
			->setMethod($Method)
			->setUrl($endPoint)
			->setFormat($format)
			->setData($data)
			->setHeaders($headers)
			->send();

		return $response;
	}

	public static function getCedisRemoteCte($idCatCedis)
	{
		return Catcedis::findOne(["id" => $idCatCedis]);
	}

	public static function setTimeStamp($time)
	{
		if ($time != null) {
			$FechaRegreso = date("Y-m-d H:i:s", strtotime($time));
			$FechaRegreso = str_replace(" ", "T", $FechaRegreso);
		} else {
			$FechaRegreso = null;
		}
		return $FechaRegreso;
	}
}
