<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "FTFACTG".
 *
 * @property string $MCVEMOV
 * @property float $MFOLIOG
 * @property string $MNUMCTE
 * @property string|null $MNUMCON
 * @property float $MALMACE
 * @property string|null $MMATRIZ
 * @property string $MAGENTE
 * @property string $MFECHAM
 * @property string|null $MFECHAR
 * @property string|null $MHORAM
 * @property string $MFECHAV
 * @property string|null $MNUMAPRO
 * @property float $MDESCTE
 * @property float $MDESCT2
 * @property float $MDESCT3
 * @property string $MCONPAG
 * @property string $MCVEIVA
 * @property string $MCVEIVAR
 * @property float $MCVEIEPS
 * @property float $MCVEISRR
 * @property string $MRAZON
 * @property string $MCALLE
 * @property string $MNUMEXT
 * @property string $MNUMINT
 * @property string $MREFEREN
 * @property string $MCOLON
 * @property string $MDELMUN
 * @property string $MCIUDAD
 * @property string|null $MCODEST
 * @property string $MCODPOS
 * @property string $MGLN
 * @property string|null $MOBSERV
 * @property string $MCVEMON
 * @property float $MTIPOCA
 * @property string $MPEDCTE
 * @property string $MLAB
 * @property string $MFLETE
 * @property string $MEMBARQ
 * @property string|null $MTALON
 * @property float $MPESON
 * @property float $MPESOB
 * @property float $MIMPFLE
 * @property float $MIMPOTR
 * @property float $MLISPRE
 * @property float $MPREESP
 * @property int $MIVAINC
 * @property int $MIEPSINC
 * @property int $MIVAREN
 * @property int $MIVARENR
 * @property int $MIEPSREN
 * @property int $MVIGIM
 * @property float $MIMPBRU
 * @property float $MIMPDES
 * @property float $MDESREN
 * @property float $MIMPCOS
 * @property float $MIMPIVA
 * @property float $MIMPIVAR
 * @property float $MIMPISRR
 * @property float $MIMPIEPS
 * @property float $MCOMAGE
 * @property string|null $MINICIA
 * @property string|null $MINIAUT
 * @property string|null $MCVECOT
 * @property float|null $MNUMCOT
 * @property float|null $MYEARAPRO
 * @property string|null $MNUMCER
 * @property string|null $MSELLO
 * @property string|null $MCADORIG
 * @property string|null $MUUID
 * @property string|null $MFECTIMBRE
 * @property string|null $MNUMCERSAT
 * @property string|null $MSELLOSAT
 * @property string|null $MXML
 * @property int $MENVIADO
 * @property string|null $MTIPOPAGO
 * @property string|null $MNUMCTAPAG
 * @property int $MPARCIAL
 * @property int $MBAJA
 * @property string|null $MCVEFAC
 * @property float|null $MNUMFAC
 * @property string|null $MTIPOPE
 * @property string $MCVEPEDIM
 * @property int $MCERORI
 * @property int|null $MSUBDIV
 * @property string|null $MNUMCERORI
 * @property string|null $MCVEINC
 * @property string|null $MNEXPCONFI
 * @property float|null $MTIPOCAEXP
 * @property float|null $MTOTUSD
 * @property string $MOBSEXP
 * @property string|null $MCONFSAT
 * @property string|null $MMETPAG
 * @property string|null $MUCFDI
 * @property string|null $MCVEREL
 * @property float|null $MFOLREL
 * @property string|null $MTIPOREL
 * @property string|null $MUUIDREL
 * @property float $MPORLOC
 * @property int $MLOCINC
 * @property int $MLOCREN
 * @property float $MPORLOCR
 * @property float $MIMPIEPSC
 * @property float $MIMPLOC
 * @property float $MIMPLOCR
 * @property string|null $MDESCBD
 * @property string|null $MCVEPSBD
 * @property string|null $MMEDSATBD
 * @property int $MVTAGLO
 * @property int $MNOREP
 * @property string|null $MPAIS
 * @property string|null $MCVECOL
 * @property string|null $MCVEMUN
 * @property string|null $MCVELOC
 * @property string|null $MCVEPAIS
 * @property string|null $MPERIOVG
 * @property string|null $MMESVG
 * @property string|null $MYEARVG
 *
 * @property FTFACTD[] $fTFACTDs
 * @property KDTRANS[] $kDTRANSs
 * @property FAAGENT $mAGENTE
 * @property SAALMAC $mALMACE
 * @property SAEDOSR $mCODEST
 * @property SACONPA $mCONPAG
 * @property FDCOTIG $mCVECOT
 * @property HAINCOT $mCVEINC
 * @property SAIMPUE $mCVEIVA
 * @property SATIPMO $mCVEMON
 * @property SACLAVE $mCVEMOV
 * @property DACLIEN $mMATRIZ
 * @property DACLIEN $mNUMCTE
 * @property HATIPOP $mTIPOPE
 */
class FTFACTG extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'FTFACTG';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['MCVEMOV', 'MFOLIOG', 'MNUMCTE', 'MALMACE', 'MAGENTE', 'MFECHAM', 'MFECHAV', 'MDESCTE', 'MDESCT2', 'MDESCT3', 'MCONPAG', 'MCVEIVA', 'MCVEIVAR', 'MCVEIEPS', 'MCVEISRR', 'MRAZON', 'MCALLE', 'MNUMEXT', 'MNUMINT', 'MREFEREN', 'MCOLON', 'MDELMUN', 'MCIUDAD', 'MCODPOS', 'MGLN', 'MCVEMON', 'MTIPOCA', 'MPEDCTE', 'MLAB', 'MFLETE', 'MEMBARQ', 'MPESON', 'MPESOB', 'MIMPFLE', 'MIMPOTR', 'MLISPRE', 'MPREESP', 'MIVAINC', 'MIEPSINC', 'MIVAREN', 'MIVARENR', 'MIEPSREN', 'MVIGIM', 'MIMPBRU', 'MIMPDES', 'MDESREN', 'MIMPCOS', 'MIMPIVA', 'MIMPIVAR', 'MIMPISRR', 'MIMPIEPS', 'MCOMAGE', 'MENVIADO', 'MPARCIAL', 'MBAJA', 'MCVEPEDIM', 'MCERORI', 'MOBSEXP', 'MPORLOC', 'MLOCINC', 'MLOCREN', 'MPORLOCR', 'MIMPIEPSC', 'MIMPLOC', 'MIMPLOCR', 'MVTAGLO', 'MNOREP'], 'required'],
            [['MFOLIOG', 'MALMACE', 'MDESCTE', 'MDESCT2', 'MDESCT3', 'MCVEIEPS', 'MCVEISRR', 'MTIPOCA', 'MPESON', 'MPESOB', 'MIMPFLE', 'MIMPOTR', 'MLISPRE', 'MPREESP', 'MIMPBRU', 'MIMPDES', 'MDESREN', 'MIMPCOS', 'MIMPIVA', 'MIMPIVAR', 'MIMPISRR', 'MIMPIEPS', 'MCOMAGE', 'MNUMCOT', 'MYEARAPRO', 'MNUMFAC', 'MTIPOCAEXP', 'MTOTUSD', 'MFOLREL', 'MPORLOC', 'MPORLOCR', 'MIMPIEPSC', 'MIMPLOC', 'MIMPLOCR'], 'number'],
            [['MFECHAM', 'MFECHAR', 'MFECHAV'], 'safe'],
            [['MIVAINC', 'MIEPSINC', 'MIVAREN', 'MIVARENR', 'MIEPSREN', 'MVIGIM', 'MENVIADO', 'MPARCIAL', 'MBAJA', 'MCERORI', 'MSUBDIV', 'MLOCINC', 'MLOCREN', 'MVTAGLO', 'MNOREP'], 'integer'],
            [['MCADORIG', 'MXML', 'MOBSEXP'], 'string'],
            [['MCVEMOV', 'MNUMCTE', 'MNUMCON', 'MMATRIZ', 'MFLETE', 'MTALON', 'MCVECOT', 'MCVEFAC', 'MCVEREL'], 'string', 'max' => 6],
            [['MAGENTE', 'MCONPAG', 'MCVEIVA', 'MCODEST', 'MCVEMON', 'MTIPOPAGO', 'MCVEINC', 'MMETPAG', 'MUCFDI', 'MMEDSATBD', 'MCVEMUN', 'MCVEPAIS'], 'string', 'max' => 3],
            [['MHORAM', 'MINICIA', 'MINIAUT'], 'string', 'max' => 8],
            [['MNUMAPRO', 'MNUMEXT', 'MNUMINT', 'MCODPOS', 'MCVEPSBD'], 'string', 'max' => 10],
            [['MCVEIVAR'], 'string', 'max' => 13],
            [['MRAZON'], 'string', 'max' => 200],
            [['MCALLE', 'MREFEREN', 'MDELMUN', 'MNEXPCONFI', 'MPAIS'], 'string', 'max' => 50],
            [['MCOLON'], 'string', 'max' => 60],
            [['MCIUDAD', 'MUUID', 'MNUMCERORI', 'MUUIDREL', 'MDESCBD'], 'string', 'max' => 40],
            [['MGLN'], 'string', 'max' => 16],
            [['MOBSERV', 'MLAB'], 'string', 'max' => 15],
            [['MPEDCTE', 'MNUMCER', 'MFECTIMBRE', 'MNUMCERSAT', 'MNUMCTAPAG'], 'string', 'max' => 20],
            [['MEMBARQ'], 'string', 'max' => 24],
            [['MSELLO', 'MSELLOSAT'], 'string', 'max' => 350],
            [['MTIPOPE', 'MCVEPEDIM'], 'string', 'max' => 1],
            [['MCONFSAT'], 'string', 'max' => 5],
            [['MTIPOREL', 'MCVELOC', 'MPERIOVG', 'MMESVG'], 'string', 'max' => 2],
            [['MCVECOL', 'MYEARVG'], 'string', 'max' => 4],
            [['MCVEMOV', 'MFOLIOG'], 'unique', 'targetAttribute' => ['MCVEMOV', 'MFOLIOG']],
            [['MALMACE'], 'exist', 'skipOnError' => true, 'targetClass' => SAALMAC::class, 'targetAttribute' => ['MALMACE' => 'LNUMALM']],
            [['MCVEIVA'], 'exist', 'skipOnError' => true, 'targetClass' => SAIMPUE::class, 'targetAttribute' => ['MCVEIVA' => 'PCVEIVA']],
            [['MCONPAG'], 'exist', 'skipOnError' => true, 'targetClass' => SACONPA::class, 'targetAttribute' => ['MCONPAG' => 'PCVECON']],
            [['MCVECOT', 'MNUMCOT'], 'exist', 'skipOnError' => true, 'targetClass' => FDCOTIG::class, 'targetAttribute' => ['MCVECOT' => 'MCVEMOV', 'MNUMCOT' => 'MFOLIOG']],
            [['MCODEST'], 'exist', 'skipOnError' => true, 'targetClass' => SAEDOSR::class, 'targetAttribute' => ['MCODEST' => 'PCVEEDO']],
            [['MAGENTE'], 'exist', 'skipOnError' => true, 'targetClass' => FAAGENT::class, 'targetAttribute' => ['MAGENTE' => 'ANUMAGE']],
            [['MMATRIZ'], 'exist', 'skipOnError' => true, 'targetClass' => DACLIEN::class, 'targetAttribute' => ['MMATRIZ' => 'DNUMCTE']],
            [['MNUMCTE'], 'exist', 'skipOnError' => true, 'targetClass' => DACLIEN::class, 'targetAttribute' => ['MNUMCTE' => 'DNUMCTE']],
            [['MCVEMOV'], 'exist', 'skipOnError' => true, 'targetClass' => SACLAVE::class, 'targetAttribute' => ['MCVEMOV' => 'PNUMERO']],
            [['MCVEINC'], 'exist', 'skipOnError' => true, 'targetClass' => HAINCOT::class, 'targetAttribute' => ['MCVEINC' => 'HCVEINC']],
            [['MTIPOPE'], 'exist', 'skipOnError' => true, 'targetClass' => HATIPOP::class, 'targetAttribute' => ['MTIPOPE' => 'HTIPOPE']],
            [['MCVEMON'], 'exist', 'skipOnError' => true, 'targetClass' => SATIPMO::class, 'targetAttribute' => ['MCVEMON' => 'PCVEMON']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'MCVEMOV' => 'Mcvemov',
            'MFOLIOG' => 'Mfoliog',
            'MNUMCTE' => 'Mnumcte',
            'MNUMCON' => 'Mnumcon',
            'MALMACE' => 'Malmace',
            'MMATRIZ' => 'Mmatriz',
            'MAGENTE' => 'Magente',
            'MFECHAM' => 'Mfecham',
            'MFECHAR' => 'Mfechar',
            'MHORAM' => 'Mhoram',
            'MFECHAV' => 'Mfechav',
            'MNUMAPRO' => 'Mnumapro',
            'MDESCTE' => 'Mdescte',
            'MDESCT2' => 'Mdesct2',
            'MDESCT3' => 'Mdesct3',
            'MCONPAG' => 'Mconpag',
            'MCVEIVA' => 'Mcveiva',
            'MCVEIVAR' => 'Mcveivar',
            'MCVEIEPS' => 'Mcveieps',
            'MCVEISRR' => 'Mcveisrr',
            'MRAZON' => 'Mrazon',
            'MCALLE' => 'Mcalle',
            'MNUMEXT' => 'Mnumext',
            'MNUMINT' => 'Mnumint',
            'MREFEREN' => 'Mreferen',
            'MCOLON' => 'Mcolon',
            'MDELMUN' => 'Mdelmun',
            'MCIUDAD' => 'Mciudad',
            'MCODEST' => 'Mcodest',
            'MCODPOS' => 'Mcodpos',
            'MGLN' => 'Mgln',
            'MOBSERV' => 'Mobserv',
            'MCVEMON' => 'Mcvemon',
            'MTIPOCA' => 'Mtipoca',
            'MPEDCTE' => 'Mpedcte',
            'MLAB' => 'Mlab',
            'MFLETE' => 'Mflete',
            'MEMBARQ' => 'Membarq',
            'MTALON' => 'Mtalon',
            'MPESON' => 'Mpeson',
            'MPESOB' => 'Mpesob',
            'MIMPFLE' => 'Mimpfle',
            'MIMPOTR' => 'Mimpotr',
            'MLISPRE' => 'Mlispre',
            'MPREESP' => 'Mpreesp',
            'MIVAINC' => 'Mivainc',
            'MIEPSINC' => 'Miepsinc',
            'MIVAREN' => 'Mivaren',
            'MIVARENR' => 'Mivarenr',
            'MIEPSREN' => 'Miepsren',
            'MVIGIM' => 'Mvigim',
            'MIMPBRU' => 'Mimpbru',
            'MIMPDES' => 'Mimpdes',
            'MDESREN' => 'Mdesren',
            'MIMPCOS' => 'Mimpcos',
            'MIMPIVA' => 'Mimpiva',
            'MIMPIVAR' => 'Mimpivar',
            'MIMPISRR' => 'Mimpisrr',
            'MIMPIEPS' => 'Mimpieps',
            'MCOMAGE' => 'Mcomage',
            'MINICIA' => 'Minicia',
            'MINIAUT' => 'Miniaut',
            'MCVECOT' => 'Mcvecot',
            'MNUMCOT' => 'Mnumcot',
            'MYEARAPRO' => 'Myearapro',
            'MNUMCER' => 'Mnumcer',
            'MSELLO' => 'Msello',
            'MCADORIG' => 'Mcadorig',
            'MUUID' => 'Muuid',
            'MFECTIMBRE' => 'Mfectimbre',
            'MNUMCERSAT' => 'Mnumcersat',
            'MSELLOSAT' => 'Msellosat',
            'MXML' => 'Mxml',
            'MENVIADO' => 'Menviado',
            'MTIPOPAGO' => 'Mtipopago',
            'MNUMCTAPAG' => 'Mnumctapag',
            'MPARCIAL' => 'Mparcial',
            'MBAJA' => 'Mbaja',
            'MCVEFAC' => 'Mcvefac',
            'MNUMFAC' => 'Mnumfac',
            'MTIPOPE' => 'Mtipope',
            'MCVEPEDIM' => 'Mcvepedim',
            'MCERORI' => 'Mcerori',
            'MSUBDIV' => 'Msubdiv',
            'MNUMCERORI' => 'Mnumcerori',
            'MCVEINC' => 'Mcveinc',
            'MNEXPCONFI' => 'Mnexpconfi',
            'MTIPOCAEXP' => 'Mtipocaexp',
            'MTOTUSD' => 'Mtotusd',
            'MOBSEXP' => 'Mobsexp',
            'MCONFSAT' => 'Mconfsat',
            'MMETPAG' => 'Mmetpag',
            'MUCFDI' => 'Mucfdi',
            'MCVEREL' => 'Mcverel',
            'MFOLREL' => 'Mfolrel',
            'MTIPOREL' => 'Mtiporel',
            'MUUIDREL' => 'Muuidrel',
            'MPORLOC' => 'Mporloc',
            'MLOCINC' => 'Mlocinc',
            'MLOCREN' => 'Mlocren',
            'MPORLOCR' => 'Mporlocr',
            'MIMPIEPSC' => 'Mimpiepsc',
            'MIMPLOC' => 'Mimploc',
            'MIMPLOCR' => 'Mimplocr',
            'MDESCBD' => 'Mdescbd',
            'MCVEPSBD' => 'Mcvepsbd',
            'MMEDSATBD' => 'Mmedsatbd',
            'MVTAGLO' => 'Mvtaglo',
            'MNOREP' => 'Mnorep',
            'MPAIS' => 'Mpais',
            'MCVECOL' => 'Mcvecol',
            'MCVEMUN' => 'Mcvemun',
            'MCVELOC' => 'Mcveloc',
            'MCVEPAIS' => 'Mcvepais',
            'MPERIOVG' => 'Mperiovg',
            'MMESVG' => 'Mmesvg',
            'MYEARVG' => 'Myearvg',
        ];
    }

    /**
     * Gets query for [[FTFACTDs]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getFTFACTDs()
    {
        return $this->hasMany(FTFACTD::class, ['MCVEMOV' => 'MCVEMOV', 'MFOLIOG' => 'MFOLIOG']);
    }

    /**
     * Gets query for [[KDTRANSs]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getKDTRANSs()
    {
        return $this->hasMany(KDTRANS::class, ['BCVEFAC' => 'MCVEMOV', 'BFOLIOFAC' => 'MFOLIOG']);
    }

    /**
     * Gets query for [[MAGENTE]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getMAGENTE()
    {
        return $this->hasOne(FAAGENT::class, ['ANUMAGE' => 'MAGENTE']);
    }

    /**
     * Gets query for [[MALMACE]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getMALMACE()
    {
        return $this->hasOne(SAALMAC::class, ['LNUMALM' => 'MALMACE']);
    }

    /**
     * Gets query for [[MCODEST]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getMCODEST()
    {
        return $this->hasOne(SAEDOSR::class, ['PCVEEDO' => 'MCODEST']);
    }

    /**
     * Gets query for [[MCONPAG]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getMCONPAG()
    {
        return $this->hasOne(SACONPA::class, ['PCVECON' => 'MCONPAG']);
    }

    /**
     * Gets query for [[MCVECOT]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getMCVECOT()
    {
        return $this->hasOne(FDCOTIG::class, ['MCVEMOV' => 'MCVECOT', 'MFOLIOG' => 'MNUMCOT']);
    }

    /**
     * Gets query for [[MCVEINC]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getMCVEINC()
    {
        return $this->hasOne(HAINCOT::class, ['HCVEINC' => 'MCVEINC']);
    }

    /**
     * Gets query for [[MCVEIVA]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getMCVEIVA()
    {
        return $this->hasOne(SAIMPUE::class, ['PCVEIVA' => 'MCVEIVA']);
    }

    /**
     * Gets query for [[MCVEMON]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getMCVEMON()
    {
        return $this->hasOne(SATIPMO::class, ['PCVEMON' => 'MCVEMON']);
    }

    /**
     * Gets query for [[MCVEMOV]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getMCVEMOV()
    {
        return $this->hasOne(SACLAVE::class, ['PNUMERO' => 'MCVEMOV']);
    }

    /**
     * Gets query for [[MMATRIZ]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getMMATRIZ()
    {
        return $this->hasOne(DACLIEN::class, ['DNUMCTE' => 'MMATRIZ']);
    }

    /**
     * Gets query for [[MNUMCTE]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getMNUMCTE()
    {
        return $this->hasOne(DACLIEN::class, ['DNUMCTE' => 'MNUMCTE']);
    }

    /**
     * Gets query for [[MTIPOPE]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getMTIPOPE()
    {
        return $this->hasOne(HATIPOP::class, ['HTIPOPE' => 'MTIPOPE']);
    }
}
